
#ifndef CRYS_HOST_TST_AES
#define CRYS_HOST_TST_AES

/***************************************************************** 
*  @file CRYS_HOST_TST_AES.h
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/

/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_NotIntegrated      
 *  
 * Inputs:
 * IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
 *                          In ECB mode this parameter has no use.
 *                          In CBC and MAC modes this parameter should containe the IV values.
 *                          in CTR mode this value shuld contain the init counter.
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
EXPORT_C DxUint32 SEPQA_AES_NotIntegrated(
                                    CRYS_AES_IvCounter_t       IVCounter_ptr,       
									CRYS_AES_Key_t             Key_ptr,
									CRYS_AES_KeySize_t         KeySize,            
									CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
									CRYS_AES_OperationMode_t   OperationMode ,      
									DxUint8_t                  Is_secret_key,       
									DxUint8_t                  *DataIn_ptr,        
									DxUint32_t                 DataInSize,
									DxUint8_t                  *ExpectedData_ptr,        
									DxUint32_t                 DataExpSize,
									int						   OutputLocation,
									char                      *FailureFunctionNameOut_ptr,        
									DxUint32_t                 FuncNameMaxSize);
									
																		
/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_Integrated      
 *  
 * Inputs:
 * IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
 *                          In ECB mode this parameter has no use.
 *                          In CBC and MAC modes this parameter should containe the IV values.
 *                          in CTR mode this value shuld contain the init counter.
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
 EXPORT_C DxUint32 SEPQA_AES_Integrated(
								CRYS_AES_IvCounter_t       IVCounter_ptr,       
								CRYS_AES_Key_t             Key_ptr,
								CRYS_AES_KeySize_t         KeySize,            
								CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								CRYS_AES_OperationMode_t   OperationMode ,      
								DxUint8_t                  Is_secret_key,       
								DxUint8_t                  *DataIn_ptr,        
								DxUint32_t                 DataInSize,
								DxUint8_t                  *ExpectedData_ptr,        
								DxUint32_t                 DataExpSize,
								int						   OutputLocation,
								char                       *FailureFunctionNameOut_ptr,        
								DxUint32_t                 FuncNameMaxSize);
									
			
/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_MAC_NON_Integrated      
 *  
 * Inputs:
 * IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
 *                          In ECB mode this parameter has no use.
 *                          In CBC and MAC modes this parameter should containe the IV values.
 *                          in CTR mode this value shuld contain the init counter.
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
 EXPORT_C DxUint32 SEPQA_AES_MAC_NON_Integrated(
								CRYS_AES_IvCounter_t       IVCounter_ptr,       
								CRYS_AES_Key_t             Key_ptr,
								CRYS_AES_KeySize_t         KeySize,            
								CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								CRYS_AES_OperationMode_t   OperationMode ,      
								DxUint8_t                  Is_secret_key,       
								DxUint8_t                  *DataIn_ptr,        
								DxUint32_t                 DataInSize,
								DxUint8_t                  *ExpectedData_ptr,        
								DxUint32_t                 DataExpSize,
								int						   OutputLocation,
								char                       *FailureFunctionNameOut_ptr,        
								DxUint32_t                 FuncNameMaxSize);
								
								
 /*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_XCBC_CMAC_NON_integrated      
 *  
 * Inputs:
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
 EXPORT_C DxUint32 SEPQA_AES_XCBC_CMAC_NON_integrated(       
								CRYS_AES_Key_t             Key_ptr,
								CRYS_AES_KeySize_t         KeySize,            
								CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								CRYS_AES_OperationMode_t   OperationMode ,      
								DxUint8_t                  Is_secret_key,       
								DxUint8_t                  *DataIn_ptr,        
								DxUint32_t                 DataInSize,
								DxUint8_t                  *ExpectedData_ptr,        
								DxUint32_t                 DataExpSize,
								int						   OutputLocation,
								char                       *FailureFunctionNameOut_ptr,        
								DxUint32_t                 FuncNameMaxSize);
													
													
									
									
 /*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_XCBC_CMAC_integrated      
 *  
 * Inputs:
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
 EXPORT_C DxUint32 SEPQA_AES_XCBC_CMAC_integrated(       
								CRYS_AES_Key_t             Key_ptr,
								CRYS_AES_KeySize_t         KeySize,            
								CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								CRYS_AES_OperationMode_t   OperationMode ,      
								DxUint8_t                  Is_secret_key,       
								DxUint8_t                  *DataIn_ptr,        
								DxUint32_t                 DataInSize,
								DxUint8_t                  *ExpectedData_ptr,        
								DxUint32_t                 DataExpSize,
								int						   OutputLocation,
								char                       *FailureFunctionNameOut_ptr,        
								DxUint32_t                 FuncNameMaxSize);
																			
																			

/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_MAC_Integrated      
 *  
 * Inputs:
 * IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
 *                          In ECB mode this parameter has no use.
 *                          In CBC and MAC modes this parameter should containe the IV values.
 *                          in CTR mode this value shuld contain the init counter.
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
 *
 * EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
 *                           Decrypt operation [1].
 *
 * OperationMode - The operation mode : ECB , CBC , MAC or CTR.
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataExpSize - The size of the expected data
 * OutputLocation - indication if input buffer == output buffer or not.
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    
 EXPORT_C DxUint32 SEPQA_AES_MAC_Integrated(
								CRYS_AES_IvCounter_t       IVCounter_ptr,       
								CRYS_AES_Key_t             Key_ptr,
								CRYS_AES_KeySize_t         KeySize,            
								CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								CRYS_AES_OperationMode_t   OperationMode ,      
								DxUint8_t                  Is_secret_key,       
								DxUint8_t                  *DataIn_ptr,        
								DxUint32_t                 DataInSize,
								DxUint8_t                  *ExpectedData_ptr,        
								DxUint32_t                 DataExpSize,
								int						   OutputLocation,
								char                       *FailureFunctionNameOut_ptr,        
								DxUint32_t                 FuncNameMaxSize);
								
	
	
/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_AES_KeyWrapUnwarp      
 *  
 * Inputs:
 * 
 *
 * Key_ptr - a pointer to the users key buffer.
 *
 * KeySize - The size of the KEY used on the AES :  256 bits as defined in the enum.
 *
 * 
 *
 * is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
 *
 * DataIn_ptr - The pointer to the buffer of the input data to the AES. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
 * ExpectedData_ptr - The pointer to the expected data of the AES operation. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * WrapdDataSize - The size of the expected data
 * 
 *
 * FailureFunctionNameOut_ptr - In case that function failures this parameter
 *                                             returns the name of the function that failures
 * FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
 
 *
 * Outputs: 
 *  DxUint32 - Function error return                                     
 *
 * Description:                                                                 
 *  This function is used to operate the qa external application on the SEP, 
 *  that executes AES not integrated test
 * Algorithm:       
 * 1. initiate and start the message 
 * 2. prepare message with all non buffer parameters of the API
 * 3. send all buffers params                                   
 * 4. end message
 * 5. wait for the response of SEP side
 * 6. start reading message from the SEP  and check returned function status from SEP
 ******************************************************************************/    							
EXPORT_C DxUint32  SEPQA_AES_KeyWrapUnwarp( CRYS_AES_Key_t             Key_ptr,
									 		CRYS_AES_KeySize_t         KeySize,                 
											DxUint8_t                  is_secret_key,       
									 		DxUint8_t                  *DataIn_ptr,        
									 		DxUint32_t                 DataInSize,
									 		DxUint8_t*                 ExpectedData_ptr,        
									 		DxUint32_t                 WrapdDataSize,
									 		char                       *FailureFunctionNameOut_ptr,        
									 		DxUint32_t                 FuncNameMaxSize);	
  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_AES */
